'use strict';

angular.module('bank_model', ['configuration_model'])
    .factory('CompanyBankService', ['$http', '$rootScope', 'Configuration', function($http, $rootScope, Configuration){
        function CompanyBankService(data){
            this.setData(data);
        }

        CompanyBankService.prototype = {
            id: 0
            ,option_id: 0
            ,round_id: 0
            ,value: 0
            ,init_value: 0
            ,_originalValue: 0
            ,_deleted: false
            ,setData: function(data){
                angular.extend(this, data);
                this._originalValue = angular.copy(this.value);
            }
            ,isChanged: function(){
                return this.value != this._originalValue;
            }
            ,isDeleted: function(){
                return this._deleted;
            }
            ,isShow: function(){
                return !this._deleted || this.id > 0;
            }
            ,getValue: function(){
                return this.value;
            }
            ,save: function(callbackSuccess, callbackError){
                var scope = this;
                var message = {
                    title: 'Opcje bankowe'
                    ,msg: 'Zapisuję dane. Proszę czekać...'
                }
                $rootScope.$broadcast('Message:addMsg', message);
                $http.post(Configuration.urlBankOption, this)
                    .success(function(data){
                        if(typeof data.error == 'undefined')
                        {
                            scope.id = data.id;
                            scope.init_value = data.init_value;
                            scope._originalValue = angular.copy(scope.value);
                        }
                        $rootScope.$broadcast('Message:delMsg', message);

                        if(typeof callbackSuccess != 'undefined')
                        {
                            callbackSuccess(scope);
                        }
                    })
                    .error(function(data){

                    })
                ;
            }
            ,setDeleted: function(){
                this._deleted = true;
            }
        }

        return CompanyBankService;
    }])
    .factory('BankServiceOption', ['CompanyBankService', function(CompanyBankService){
        function BankServiceOption(data){
            this.setData(data);
        }

        BankServiceOption.prototype = {
            company_bank_service_options: []
            ,checked: false
            ,setData: function(data){
                angular.extend(this, data);

                this.company_bank_service_options.forEach(function(optionData, key){
                    this.company_bank_service_options[key] = new CompanyBankService(optionData);
                }, this);
            }
            ,isUsed: function(){
                if(this.flags == 'RB')
                {
                    return true;
                }

                var isUsed = false;
                for(var i = 0; i < this.company_bank_service_options.length; i++)
                {
                    if(this.company_bank_service_options[i].id != null && (this.company_bank_service_options[i].value != 0 || (this.company_bank_service_options[i].value == 0 && this.company_bank_service_options[i].id != 0)))
                    {
                        isUsed = true;
                        break;
                    }
                }
                return isUsed;
//                return (this.getTotalValue() > 0);
            }
            ,isChecked: function(){
                return this.checked;
            }
            ,addCompanyBankService: function(){
                this.company_bank_service_options.push(new CompanyBankService({option_id: this.id, round_id: roundId}));
            }
            ,getTotalValue: function(){
                var totalValue = 0;
                this.company_bank_service_options.forEach(function(optionData){
                    totalValue += parseFloat(optionData.value);
                }, this);

                return totalValue;
            }
            ,removeAllCompanyBankServices: function(){
                this.company_bank_service_options = [];
            }
            ,removeCompanyBankService: function(cbso){
                cbso.value = 0;
                cbso.setDeleted();
                return true;
            }
            ,getChanged: function(){
                var changes = [];
                this.company_bank_service_options.forEach(function(cbso){
                    if(cbso.isChanged())
                    {
                        changes.push(cbso);
                    }
                });
                return changes;
            }
        }

        return BankServiceOption;
    }])
    .factory('BankService', ['BankServiceOption', function(BankServiceOption){
        function BankService(data){
            this.setData(data);
        }

        BankService.prototype = {
            types: []
            ,setData: function(data){
                angular.extend(this, data);
                this.types.forEach(function(typeData, key){
                    typeData.company_bank_service_options = [];
                    data.items.forEach(function(cbso){
                        if(cbso.option_id ==typeData.id)
                        {
                            typeData.company_bank_service_options.push(cbso);
                        }
                    });

                    this.types[key] = new BankServiceOption(typeData);
                }, this);
            }
            ,isUsed: function(){
                var isUsed = false;
                for(var i = 0; i < this.types.length; i++)
                {
                    if(this.types[i].isUsed())
                    {
                        isUsed = true;
                        break;
                    }
                }
                return isUsed;
            }
            ,getAllChanges: function(){
                var changes = [];
                angular.forEach(this.types, function(BankServiceOption){
                    angular.forEach(BankServiceOption.getChanged(), function(cbso){
                        changes.push({cbso: cbso, option: BankServiceOption});
                    });
                });
                return changes;
            }
            ,findOption: function(id){
                var found = false;
                for(var i = 0; i < this.types.length; i++)
                {
                    if(this.types[i].id == id)
                    {
                        found = this.types[i];
                        break;
                    }
                }
                return found;
            }
        }

        return BankService;
    }])
    .factory('BanksList', ['$http', '$q', 'Configuration', 'BankService', function($http, $q, Configuration, BankService){
        var BanksList = {
            _isLoadedData: false
            ,_list: []
            ,_originalList :[]
            ,loadData: function(){
                if(this._isLoadedData)
                {
                    return this._list;
                }

                var defer = $q.defer();
                var scope = this;

                $http.get(Configuration.urlBanksList)
                    .success(function(data){
                        scope._list = [];
                        data.forEach(function(data){
                            var BankServiceData = data.bs;
                            BankServiceData.items = data.items;
                            scope._list.push(new BankService(BankServiceData));
                        });
//                        scope.copyToOriginalList();
                        scope._isLoadedData = true;
                        defer.resolve(scope._list);
                    })
                    .error(function(data){
                        defer.reject();
                    })
                ;

                return defer.promise;
            }

            ,copyToOriginalList: function(){
                this._originalList = angular.copy(this._list);
            }

            ,findBankServiceBySymbol: function(symbol){
                var found = false;
                for(var i = 0; i < this._list.length; i++)
                {
                    if(this._list[i].symbol == symbol)
                    {
                        found = this._list[i];
                        break;
                    }
                }
                return found;
            }

            // pobierz rachunek bieżący
            ,getCurrentAccount: function(){
                var BankAccountService = this.findBankServiceBySymbol('CURRENT_ACCOUNT');
                var CurrentAccount = false;
                for(var i = 0; i < BankAccountService.types.length; i++)
                {
                    if(BankAccountService.types[i].company_bank_service_options.length > 0)
                    {
                        CurrentAccount = BankAccountService.types[i];
                        break;
                    }
                }
                return CurrentAccount;
            }

            ,getLoanOptions: function(){
                var BankAccountService = this.findBankServiceBySymbol('CREDIT');
                return BankAccountService.types;
            }

            ,isChanged: function(){
                var changed = (this.getCurrentAccount().getChanged().length>0);
                if(!changed)
                {
                    this._list.forEach(function(BankService){
                        if(BankService.symbol == 'CREDIT')
                        {
                            BankService.types.forEach(function(BankServiceOption){
                                if(BankServiceOption.getChanged().length > 0)
                                {
                                    changed = true;
                                }
                            })
                        }
                        if(BankService.symbol == 'INVESTMENT')
                        {
                            BankService.types.forEach(function(BankServiceOption){
                                if(BankServiceOption.getChanged().length > 0)
                                {
                                    changed = true;
                                }
                            })
                        }
                    });
                }


                return changed;
            }

            ,setReloadData: function(){
                this._isLoadedData = false;
            }

            ,getOptionFullName: function(optionId){
                var name = '';
                for(var i = 0; i < this._list.length; i++){
                    name = this._list[i].name;
                    var option = this._list[i].findOption(optionId);
                    if(option !== false)
                    {
                        name += ' ' + option.name;
                        break;
                    }
                }
                return name;
            }
        };

        return BanksList;
    }])
    .factory('BankAccountChanges', ['$http', '$q', 'Configuration', function($http, $q, Configuration){
        var BankAccountChanges = {
            _list: []
            ,loadData: function(accountId, callbackSuccess, callbackError){
                var defer = $q.defer();
                var scope = this;

                $http.get(Configuration.urlBankAccountChanges + '/' + accountId)
                    .success(function(data){
                        scope._list = data;
                        scope._isLoadedData = true;
                        defer.resolve(scope._list);
                        if(typeof callbackSuccess != 'undefined')
                        {
                            callbackSuccess(data);
                        }
                    })
                    .error(function(data){
                        defer.reject();
                        if(typeof callbackError != 'undefined')
                        {
                            callbackError(data);
                        }
                    })
                ;

                return defer.promise;
            }
        };

        return BankAccountChanges;
    }])
;